﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

/*
 * Delete reference VTLB2
 * Add reference Browse VTLB2.dll
 * Nieuwe Stylesheet kopieren naar juiste plek
 * 
 * 
 * 
*/
using VTLB;

namespace CSharpTestaanroepByRef
{
    public partial class Form1 : Form
    {

        string sVersie = "?.?";

        public Form1()
        {
            InitializeComponent();
            TraceListener debugListener = new MyTraceListener(tbLog);
            Trace.Listeners.Add(debugListener);

            Trace.Write("Form1 VTTLB "+sVersie);

            tbDatumBerekening.Text = DateTime.Now.ToString("yyyyMMdd");
        }

        private void button2_Click(object sender, EventArgs e)
        {
            Trace.Write("");
            Trace.Write("");
            Trace.Write(String.Empty.PadRight(80, '-'));
            Trace.Write("VTLB Berekening aanroep ByRef");
            Trace.Write("");
            VTLB.TInvoerRecord Inv = new VTLB.TInvoerRecord();
            VTLB.TVTLBExtra Extra = new VTLB.TVTLBExtra();
            VTLB.TUitvoerRecord Uit = new VTLB.TUitvoerRecord();

            try
            {
                VTLB.VTLBBerekening ber = new VTLB.VTLBBerekening();


                VTLB.TVersieRecord ver;
                ber.GeefVersieInformatie(out ver);
                sVersie = ver.berPlugInVersieMajor + "." + ver.berPlugInVersieMinor;
                Trace.Write("  Versie=" + sVersie);

                ber.InitialiseerInvoer(out Inv);
                double dubbel = 0;
                ber.GeefParameterWaarde(0, 114, out dubbel);
                Trace.Write("  >>ber.GeefParameterWaarde(0,114)="+dubbel.ToString());
                double dubbel2 = 0;
                ber.GeefParameterWaarde(0, 2, out dubbel);
                Trace.Write("  >>ber.GeefParameterWaarde(0,2)=" + dubbel2.ToString());
                //pIVTLBBerekening->GeefParameterWaarde(0,114,&dPar114);
                Inv.berBerekeningsversie = Convert.ToInt32(tbBerekeningsversie.Text);
                Inv.berDatumBerekening = Convert.ToInt32(tbDatumBerekening.Text); 

                Inv.schGeboortedatum = Convert.ToInt32(dateTimePicker1.Value.ToString("yyyyMMdd"));

                Inv.schInkWerk = 1500;
                Inv.schInkWerkEx = new VTLB.TInkomen1Auto();
                Inv.schInkWerkEx.Netto = 1200;
                Inv.schInkWerkEx.Vakantiegeld = 54.54;
                Inv.schInkWerkEx.Auto = 218;
                
                Inv.schInkAOW = 310;
                Inv.schInkANW = 320;

                VTLB.TKindRecord Kind = new VTLB.TKindRecord();
                Kind.GeboorteDatum = 20051112;
                Kind.SoortOnderwijs = VTLB.TSoortOnderwijs.soVOBovenbouw;
                ber.KindAdd_ByRef(ref Kind);
                Kind.GeboorteDatum = 19880523;
                Kind.SoortOnderwijs = VTLB.TSoortOnderwijs.soVOOnderbouw;
                ber.KindAdd_ByRef(ref Kind);
                Kind.GeboorteDatum = 20180318;
                Kind.SoortOnderwijs = VTLB.TSoortOnderwijs.soGeen;
                ber.KindAdd_ByRef(ref Kind); 
            
                Inv.kndInwonendAantal = 3;
                Inv.schUitgCorrectieBeschermBudget = 8.67;
                Inv.parUitgCorrectieBeschermBudget = 13.24;

                Extra.xslNaam = "VTLBCalculator " + sVersie + ".xsl";
                Extra.xmlNaam = "VTLBBerekeningC.xml";
                Extra.xmlTonen = VTLB.TJaNee.jnJa;
                int idatum = 0;
                Int32.TryParse(textBox10.Text, out idatum);
                Extra.berGeldigVan = idatum;
                idatum = 0;
                Int32.TryParse(textBox11.Text, out idatum);
                Extra.berGeldigTem = idatum;
                Extra.schNaam = "ByREF " + textBox1.Text; ;
                Extra.schInsolventieNr = "";
                Extra.schDatumToepWsnp = 20211216;
                Extra.schStartdatumLptWsnp = 20221216;
                Extra.schToelichting = "*** Toelichting op overige correcties van schuldenaar op berekening ***";

                Extra.srcVersie = "2023.01";			
                Extra.srcRelease = "1";


                ber.ToonVTLBBerekening_ByRef(ref Inv, out Uit, ref Extra);


                textBox2.Text = Extra.xmlNaam;
                int iAantalKinderen = Uit.kndAantalInwonend;
                textBox3.Text = iAantalKinderen.ToString();

                textBox4.Text = Uit.schLeeftijd.ToString();
                textBox5.Text = string.Format("{0}.{1}.{2}", Uit.berPlugInVersieMajor, Uit.berPlugInVersieMinor, Uit.berPlugInVersieRelease);

                textBox6.Text = Uit.berPlugInIngangsDatum.ToString();
                textBox7.Text = Uit.berGebruikteBerekeningsDatum.ToString();
                textBox8.Text = Uit.berGebruikteBerekeningsVersie.ToString();

                textBox9.Text = Uit.bvvSchPortaalMeldingen;

                if (Uit.berFoutCode == 0)
                {
                    Trace.Write("  >> Berekening gelukt");
                }
                else
                {
                    Trace.Write("  >> " + string.Format("Error-{0}", Uit.berFoutCode));
                }

            }
            catch (Exception except)
            {
                Trace.Write("  >> ");
                Trace.Write("  >> " + except.Message);
                Trace.Write("  >> ");
            }
        }

        private void button3_Click(object sender, EventArgs e)
        {
            Trace.Write("");
            Trace.Write("");
            Trace.Write(String.Empty.PadRight(80, '-'));
            Trace.Write("VTLB Berekening standaard aanroep");
            Trace.Write("");
            VTLB.TInvoerRecord Inv = new VTLB.TInvoerRecord();
            VTLB.TVTLBExtra Extra = new VTLB.TVTLBExtra();
            VTLB.TUitvoerRecord Uit = new VTLB.TUitvoerRecord();

            try
            {
                VTLB.VTLBBerekening ber = new VTLB.VTLBBerekening();
                
                VTLB.TVersieRecord ver;
                ber.GeefVersieInformatie(out ver);
                sVersie = ver.berPlugInVersieMajor + "." + ver.berPlugInVersieMinor;
                Trace.Write("  Versie=" + sVersie);

                ber.InitialiseerInvoer(out Inv);
                double dubbel = 0;
                ber.GeefParameterWaarde(0, 114, out dubbel);
                Trace.Write("  >>ber.GeefParameterWaarde(0,114)=" + dubbel.ToString());
                //pIVTLBBerekening->GeefParameterWaarde(0,114,&dPar114);
                Inv.berBerekeningsversie = Convert.ToInt32(tbBerekeningsversie.Text);
                Inv.berDatumBerekening = Convert.ToInt32(tbDatumBerekening.Text);

                Inv.schGeboortedatum = Convert.ToInt32(dateTimePicker1.Value.ToString("yyyyMMdd"));
                Inv.schInkAOW = 310;
                Inv.schInkANW = 320;

                Inv.schInkWerk = 1500;
                Inv.schInkWerkEx = new VTLB.TInkomen1Auto();
                Inv.schInkWerkEx.Netto = 1200;
                Inv.schInkWerkEx.Vakantiegeld = 54.54;
                Inv.schInkWerkEx.Auto = 218;

                
                VTLB.TKindRecord Kind = new VTLB.TKindRecord();
                Kind.GeboorteDatum = 20051112;
                Kind.SoortOnderwijs = VTLB.TSoortOnderwijs.soVOBovenbouw;
                ber.KindAdd(Kind);
                Kind.GeboorteDatum = 20000523;
                Kind.SoortOnderwijs = VTLB.TSoortOnderwijs.soVOOnderbouw;
                ber.KindAdd(Kind);
                Kind.GeboorteDatum = 20180318;
                Kind.SoortOnderwijs = VTLB.TSoortOnderwijs.soGeen;
                ber.KindAdd(Kind);

                Inv.kndInwonendAantal = 3;
                Inv.schUitgCorrectieBeschermBudget = 8.67;
                Inv.parUitgCorrectieBeschermBudget = 13.24;

                Extra.xslNaam = "VTLBCalculator "+sVersie+".xsl";
                Extra.xmlNaam = "VTLBBerekeningC.xml";
                Extra.xmlTonen = VTLB.TJaNee.jnJa;
                int idatum = 0;
                Int32.TryParse(textBox10.Text, out idatum);
                Extra.berGeldigVan = idatum;
                idatum = 0;
                Int32.TryParse(textBox11.Text, out idatum);
                Extra.berGeldigTem = idatum;
                Extra.schNaam = "Std " + textBox1.Text; ;
                Extra.schInsolventieNr = "";
                Extra.schDatumToepWsnp = 20231216;
                Extra.schStartdatumLptWsnp = 20220516;
                Extra.schToelichting = "*** Toelichting op overige correcties van schuldenaar op berekening ***";

                Extra.srcVersie = "2021.03";
                Extra.srcRelease = "1";


                ber.ToonVTLBBerekening(Inv, out Uit, Extra);


                textBox2.Text = Extra.xmlNaam;
                int iAantalKinderen = Uit.kndAantalInwonend;
                textBox3.Text = iAantalKinderen.ToString();

                textBox4.Text = Uit.schLeeftijd.ToString();
                textBox5.Text = string.Format("{0}.{1}.{2}", Uit.berPlugInVersieMajor, Uit.berPlugInVersieMinor, Uit.berPlugInVersieRelease);

                textBox6.Text = Uit.berPlugInIngangsDatum.ToString();
                textBox7.Text = Uit.berGebruikteBerekeningsDatum.ToString();
                textBox8.Text = Uit.berGebruikteBerekeningsVersie.ToString();

                textBox9.Text = Uit.bvvSchPortaalMeldingen;

                if (Uit.berFoutCode == 0)
                {
                    Trace.Write("  >> Berekening gelukt");
                }
                else
                {
                    Trace.Write("  >> " + string.Format("Error-{0}", Uit.berFoutCode));
                }

            }
            catch (Exception except)
            {
                Trace.Write("  >> ");
                Trace.Write("  >> " + except.Message);
                Trace.Write("  >> ");
            }

        }
    }
    public class MyTraceListener : TraceListener
    {
        private TextBoxBase output;

        public MyTraceListener(TextBoxBase output)
        {
            this.Name = "Trace";
            this.output = output;
        }


        public override void Write(string message)
        {

            Action append = delegate()
            {
                output.AppendText(string.Format("[{0}] ", DateTime.Now.ToString()));
                output.AppendText(message+"\r\n");
            };
            if (output.InvokeRequired)
            {
                output.BeginInvoke(append);
            }
            else
            {
                append();
            }

        }

        public override void WriteLine(string message)
        {
            Write(message + Environment.NewLine);
        }
    }
}
